/*:
 * @plugindesc プラグインコマンドで指定したURLに自動的にアクセスするプラグイン
 * @author nikutomochi
 *
 * @help
 * プラグインコマンド:
 *   AutoLink http://example.com
 */

(function() {
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'AutoLink') {
            var url = args[0];
            if (url) {
                if (Utils.isNwjs()) {
                    var nw = require('nw.gui');
                    nw.Shell.openExternal(url);
                } else {
                    window.open(url);
                }
            }
        }
    };
})();